"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
require('dotenv').config();
const express_1 = __importDefault(require("express"));
const morgan_1 = __importDefault(require("morgan"));
const cron_1 = __importDefault(require("./src/utils/cron"));
const config_1 = __importDefault(require("./src/utils/config"));
const constants_1 = __importDefault(require("./src/utils/constants"));
const colors_1 = __importDefault(require("colors"));
const services_1 = __importDefault(require("./src/utils/services"));
const http_1 = __importDefault(require("http"));
const socket_io_1 = require("socket.io");
const sockets_1 = __importDefault(require("./src/utils/sockets"));
const sockets_2 = __importDefault(require("./src/api/users/sockets"));
const sockets_3 = __importDefault(require("./src/api/messages/sockets"));
const sockets_4 = __importDefault(require("./src/api/chats/sockets"));
const schedules_1 = __importDefault(require("./src/api/users/schedules"));
const app = (0, express_1.default)();
app.use(config_1.default.helmet);
app.use((0, morgan_1.default)('dev'));
app.use(express_1.default.json());
app.use('/docs', express_1.default.static('public'));
app.use(config_1.default.cors);
if (!config_1.default.isProduction) {
    app.use('/api', config_1.default.limiter);
}
app.all(['/', '/api'], (_, res) => res.json({ message: 'server running ⚡⚡' }));
// User API routes
app.use('/api/auth', require('./src/api/auth/routes'));
app.use('/api/users', require('./src/api/users/routes'));
app.use('/api/contacts', require('./src/api/contacts/routes'));
app.use('/api/followers', require('./src/api/followers/routes'));
app.use('/api/statuses', require('./src/api/statuses/routes'));
app.use('/api/connections', require('./src/api/connections/routes'));
app.use('/api/reels', require('./src/api/reels/routes'));
app.use('/api/views', require('./src/api/views/routes'));
app.use('/api/shares', require('./src/api/shares/routes'));
app.use('/api/likes', require('./src/api/likes/routes'));
app.use('/api/super-likes', require('./src/api/super-likes/routes'));
app.use('/api/comments', require('./src/api/comments/routes'));
app.use('/api/favorites', require('./src/api/favorites/routes'));
app.use('/api/blockings', require('./src/api/blockings/routes'));
app.use('/api/notifications', require('./src/api/notifications/routes'));
app.use('/api/chats', require('./src/api/chats/routes'));
app.use('/api/messages', require('./src/api/messages/routes'));
app.use('/api/requests', require('./src/api/requests/routes'));
app.use('/api/events', require('./src/api/events/routes'));
app.use('/api/contact-us', require('./src/api/contact-us/routes'));
app.use('/api/reports', require('./src/api/reports/routes'));
app.use('/api/rewards', require('./src/api/rewards/routes'));
app.use('/api/reward-hashes', require('./src/api/reward-hashes/routes'));
app.use('/api/scores', require('./src/api/scores/routes'));
app.use('/api/misc', require('./src/api/misc/routes'));
app.use('/api/usages', require('./src/api/usages/routes'));
// Admin API routes
app.use('/api/admin', require('./src/api/admin/routes'));
app.use('/api/admin/auth', require('./src/api/auth/admin/routes'));
app.use('/api/admin/users', require('./src/api/users/admin/routes'));
app.use('/api/admin/rewards', require('./src/api/rewards/admin/routes'));
app.use('/api/admin/reels', require('./src/api/reels/admin/routes'));
app.use(config_1.default.errorHandler);
app.use((req, res) => res.status(405).json({ message: 'route not implemented' }));
const server = http_1.default.createServer(app);
constants_1.default.io = new socket_io_1.Server(server);
// deleting all files in temp folder
services_1.default.clearTempFolder();
server.listen(process.env.PORT, () => __awaiter(void 0, void 0, void 0, function* () {
    console.log('INFO: '.green + 'Server started!');
    // connecting mongodb
    const client = yield config_1.default.mongooseConnection;
    constants_1.default.db = client.connection;
    console.log('INFO: '.green + 'Atlas connected!');
    console.log('INFO: '.green + 'Cronjob started!');
    // socket init
    constants_1.default.io.use(sockets_1.default.authorize);
    constants_1.default.io.on('connection', sockets_1.default.onInit);
    constants_1.default.socketHandlers = Object.assign(Object.assign(Object.assign({}, sockets_2.default), sockets_3.default), sockets_4.default);
    constants_1.default.scheduleHandlers = Object.assign({}, schedules_1.default);
}));
constants_1.default.firebaseAdmin = config_1.default.firebaseAdmin;
constants_1.default.cron = cron_1.default;
constants_1.default.colors = colors_1.default;
services_1.default;
