"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Admin = void 0;
const mongoose_1 = require("mongoose");
const models_1 = require("../users/models");
const AdminSchema = new mongoose_1.Schema({
    name: {
        type: String,
        required: true,
        trim: true,
    },
    email: {
        type: String,
        required: true,
        unique: true,
        match: /^[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,}$/i
    },
    phone: String,
    auth: {
        type: models_1.AuthSchema,
        required: true,
    },
}, { versionKey: false, timestamps: true });
exports.Admin = (0, mongoose_1.model)('Admin', AdminSchema, 'admins');
