"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("../../admin/models");
const helpers_1 = __importDefault(require("../../../utils/helpers"));
function postLogin(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let { email, password } = req.body;
            const admin = yield models_1.Admin.findOne({ email });
            if (!admin) {
                return res.status(404).json({ message: 'admin not found' });
            }
            const hash = helpers_1.default.getHash(password);
            if (admin.auth.password !== hash) {
                return res.status(401).json({ message: 'authentication failed' });
            }
            // @ts-ignore
            const token = helpers_1.default.getToken(admin);
            return res.json({ token });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    postLogin,
};
exports.default = controllers;
