"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
function postLogin(req, res, next) {
    try {
        const rules = {
            email: 'email',
            password: 'string|min:6|max:16',
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    postLogin
};
exports.default = validations;
