"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.post('/login', validations_1.default.postLogin, controllers_1.default.postLogin);
router.post('/google-login', validations_1.default.postGoogleLogin, controllers_1.default.postGoogleLogin);
router.post('/register', validations_1.default.postRegister, controllers_1.default.postRegister);
router.post('/send-otp', validations_1.default.postSendOtp, controllers_1.default.postSendOtp);
router.post('/check-otp', validations_1.default.postCheckOtp, controllers_1.default.postCheckOtp);
router.post('/verify', validations_1.default.postVerify, controllers_1.default.postVerify);
// router.post('/verify-2fa', validations.postVerify2FA, controllers.postVerify2FA)
router.post('/reset-password', validations_1.default.postResetPassword, controllers_1.default.postResetPassword);
router.post('/logout', auth_1.default.authorizeUser, controllers_1.default.postLogout);
module.exports = router;
