"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
function postLogin(req, res, next) {
    try {
        const rules = {
            email: 'email',
            password: 'string|min:8|max:16',
            phone: 'optional|boolean',
            remember: 'optional|boolean',
            platform: 'string|enums:android,ios,web',
            fcmToken: 'optional|string|min:50|max:300'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postGoogleLogin(req, res, next) {
    try {
        const rules = {
            googleToken: 'string|min:100|max:5000',
            remember: 'optional|boolean',
            platform: 'string|enums:android,ios,web',
            fcmToken: 'optional|string|min:50|max:300'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postRegister(req, res, next) {
    try {
        const rules = {
            email: 'email',
            password: 'string|min:8|max:16',
            dob: 'dateonly',
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postSendOtp(req, res, next) {
    try {
        const rules = {
            email: 'email',
            phone: 'optional|boolean'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postCheckOtp(req, res, next) {
    try {
        const rules = {
            email: 'email',
            otp: 'string|natural|size:4',
            phone: 'optional|boolean'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postVerify(req, res, next) {
    try {
        const rules = {
            email: 'email',
            otp: 'string|natural|size:4',
            phone: 'optional|boolean',
            platform: 'string|enums:android,ios,web',
            fcmToken: 'optional|string|min:50|max:300'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postVerify2FA(req, res, next) {
    try {
        const rules = {
            '2faToken': 'string|min:10|max:1000',
            otp: 'string|natural|size:4',
            fcmToken: 'optional|string|min:50|max:300'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postResetPassword(req, res, next) {
    try {
        const rules = {
            email: 'email',
            otp: 'string|natural|size:4',
            password: 'string|min:8|max:16',
            phone: 'optional|boolean'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    postLogin,
    postGoogleLogin,
    postRegister,
    postVerify,
    postVerify2FA,
    postSendOtp,
    postCheckOtp,
    postResetPassword,
};
exports.default = validations;
