"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getBlockings, auth_1.default.authorizeUser, controllers_1.default.getBlockings);
router.post('/:userId', validations_1.default.checkBlockingId, auth_1.default.authorizeUser, controllers_1.default.postBlocking);
router.delete('/:userId', validations_1.default.checkBlockingId, auth_1.default.authorizeUser, controllers_1.default.deleteBlocking);
module.exports = router;
