[Goto Home](/docs/index.html)

# 🔒 GET `/chats`

## Description

- Returns the list of chats of that user as per pagination
- Also populate `lastMessage` and `unread` messages count

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items
- **search** - return chats with matching chat name
- **group** - if `true`, then returns group chats only; if `false` returns one-to-one chat only; by default, returns all types of chats
- **meetMeOnly** - default `false`; if `true`, then returns only meet me chats; This only applies for one-to-one chats (i.e. when `group` is `false`)

## Response Body

```json
{
  "chats": [
    {
      "_id": "68d134f972f149b17a222c03",
      "creator": {
        "_id": "68c7f963d4ec4fd41b3e804b",
        "name": "Max_R",
        "username": "Max123_ABC",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg"
      },
      "user": {
        "_id": "68ca8ae145040eb96218240d",
        "name": "ManeeshaGKrishnan",
        "username": "Maneesha_1997",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ca8ae145040eb96218240d/1759231691262-33516198257750063-1759231693161-3b71919f-9842-44ae-86e4-b754b9cb0432.jpeg.jpg",
        "isOnline": true
      },
      "participants": [
        {
          "user": {
            "_id": "68c7f963d4ec4fd41b3e804b",
            "name": "Max_R",
            "username": "Max123_ABC",
            "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg",
            "isOnline": true
          },
          "isAdmin": true,
          "_id": "68d134f972f149b17a222c04",
          "lastReadAt": "2025-09-25T10:52:56.333Z"
        },
        {
          "user": {
            "_id": "68ca8ae145040eb96218240d",
            "name": "ManeeshaGKrishnan",
            "username": "Maneesha_1997",
            "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ca8ae145040eb96218240d/1759231691262-33516198257750063-1759231693161-3b71919f-9842-44ae-86e4-b754b9cb0432.jpeg.jpg",
            "isOnline": true
          },
          "_id": "68d134f972f149b17a222c05",
          "lastReadAt": "2025-10-01T10:28:09.532Z"
        }
      ],
      "createdAt": "2025-09-22T11:37:29.500Z",
      "updatedAt": "2025-10-01T10:28:09.533Z",
      "tags": [
        {
          "tag": "exams",
          "label": "Exams"
        },
        {
          "tag": "lectures",
          "label": "Lectures & Summaries"
        }
      ],
      "name": "ManeeshaGKrishnan",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ca8ae145040eb96218240d/1759231691262-33516198257750063-1759231693161-3b71919f-9842-44ae-86e4-b754b9cb0432.jpeg.jpg",
      "unread": 0,
      "lastMessage": null,
      "isJoined": true,
      "participantsCount": 2,
      "category": "Study"
    },
    {
      "_id": "68d51a529caa6111e7e801c7",
      "creator": {
        "_id": "68d3ad2c77362943f0d68eb4",
        "name": "Neha Sharma",
        "username": "Neha_Sharma45"
      },
      "user": {
        "_id": "68c7f963d4ec4fd41b3e804b",
        "name": "Max_R",
        "username": "Max123_ABC",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg",
        "isOnline": true
      },
      "participants": [
        {
          "user": {
            "_id": "68d3ad2c77362943f0d68eb4",
            "name": "Neha Sharma",
            "username": "Neha_Sharma45"
          },
          "isAdmin": true,
          "_id": "68d51a529caa6111e7e801c8",
          "lastReadAt": "2025-09-25T10:40:25.903Z"
        },
        {
          "user": {
            "_id": "68c7f963d4ec4fd41b3e804b",
            "name": "Max_R",
            "username": "Max123_ABC",
            "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg",
            "isOnline": true
          },
          "_id": "68d51a529caa6111e7e801c9",
          "lastReadAt": "2025-09-30T11:43:39.217Z"
        }
      ],
      "createdAt": "2025-09-25T10:32:50.265Z",
      "updatedAt": "2025-10-01T06:52:27.110Z",
      "lastMessage": {
        "_id": "68d51f2b9caa6111e7e8079a",
        "user": {
          "_id": "68c7f963d4ec4fd41b3e804b",
          "name": "Max_R",
          "username": "Max123_ABC",
          "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg"
        },
        "chat": "68d51a529caa6111e7e801c7",
        "files": [
          {
            "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68d51a529caa6111e7e801c7/1758797609557-20670695416285156-1000231137.jpg",
            "meta": {
              "mediaType": "image",
              "fileName": "1000231137.jpg",
              "fileSize": 56808,
              "duration": null
            },
            "_id": "68d51f2b9caa6111e7e8079b"
          }
        ],
        "at": "2025-09-25T10:53:31.000Z"
      },
      "tags": [
        {
          "tag": "exams",
          "label": "Exams"
        },
        {
          "tag": "lectures",
          "label": "Lectures & Summaries"
        }
      ],
      "name": "Neha Sharma",
      "unread": 0,
      "isJoined": true,
      "areYouAdmin": true,
      "participantsCount": 2,
      "category": "Study"
    }
  ],
  "count": 2
}
```

# 🔒 GET `/chats/explore/communities`

## Description

- Returns the list of trending chats/communities as per pagination
- Also populate `reels` and `unread` messages count
- Also add any pending `request` field, if exist for that chat

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items
- **search** - required field, minimum 3 characters, return chats with matching chat name
- **category** - return chats with matching category filter
- **reelsLimit** - return the given number of reels in each chat; default `5`

## Response Body

```json
{
  "chats": [
    {
      "_id": "68ee530a808e28d0b11beec9",
      "creator": {
        "_id": "68914287e4c3076d9436523c",
        "name": "Amy Jackson",
        "username": "amy.jackson",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68914287e4c3076d9436523c/1755602563034-2531577078744356-1755602562142-IMG_0006.jpg.jpg"
      },
      "isGroup": true,
      "name": "Pool Party",
      "allowPublicPost": true,
      "tags": [],
      "participants": [
        {
          "user": "68914287e4c3076d9436523c",
          "isAdmin": true,
          "_id": "68ee530a808e28d0b11beeca",
          "lastReadAt": "2025-10-14T13:41:30.000Z"
        }
      ],
      "event": "68ee530a808e28d0b11beecb",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68ee530a808e28d0b11beec9/1760449289304-22034956871186895-tree.png",
      "createdAt": "2025-10-14T13:41:32.673Z",
      "updatedAt": "2025-10-21T13:52:39.728Z",
      "restricted": true,
      "reelsCount": 1,
      "request": {
        "_id": "68f79066d1e7aee6fc6aa948",
        "user": "68ac3f6dd7f5a437029aa88f",
        "chat": "68ee530a808e28d0b11beec9",
        "status": "pending",
        "createdAt": "2025-10-21T13:53:42.000Z"
      },
      "reels": [
        {
          "_id": "68ee520d808e28d0b11beeb1",
          "user": {
            "_id": "68914287e4c3076d9436523c",
            "name": "Amy Jackson",
            "username": "amy.jackson",
            "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68914287e4c3076d9436523c/1755602563034-2531577078744356-1755602562142-IMG_0006.jpg.jpg",
            "isFollowed": false
          },
          "chat": "68ee530a808e28d0b11beec9",
          "description": "Pool party",
          "tag": "Party",
          "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68ee520d808e28d0b11beeb1/1760449037012-5410977621234984-motivation.mp4",
          "hashtags": [],
          "isAnonymous": false,
          "views": 0,
          "likes": 0,
          "superLikes": 0,
          "shares": 0,
          "comments": 0,
          "createdAt": "2025-10-14T13:54:20.084Z",
          "updatedAt": "2025-10-14T13:54:20.084Z",
          "isLiked": false,
          "isSuperLiked": false,
          "isFavorite": false
        }
      ],
      "isJoined": false,
      "areYouAdmin": true,
      "participantsCount": 1
    }
  ],
  "count": 1
}
```

# 🔒 GET `/chats/:id`

## Description

- Returns the chat details as per id
- User must belong to that chat
- Also populate `lastMessage` and `unread` messages count

## Response Body

```json
{
  "chat": {
    "_id": "68d51a529caa6111e7e801c7",
    "creator": {
      "_id": "68d3ad2c77362943f0d68eb4",
      "name": "Neha Sharma",
      "username": "Neha_Sharma45"
    },
    "user": {
      "_id": "68c7f963d4ec4fd41b3e804b",
      "name": "Max_R",
      "username": "Max123_ABC",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg"
    },
    "participants": [
      {
        "user": {
          "_id": "68d3ad2c77362943f0d68eb4",
          "name": "Neha Sharma",
          "username": "Neha_Sharma45"
        },
        "isAdmin": true,
        "_id": "68d51a529caa6111e7e801c8",
        "lastReadAt": "2025-09-25T10:40:25.903Z"
      },
      {
        "user": {
          "_id": "68c7f963d4ec4fd41b3e804b",
          "name": "Max_R",
          "username": "Max123_ABC",
          "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg",
          "isOnline": true
        },
        "_id": "68d51a529caa6111e7e801c9",
        "lastReadAt": "2025-09-30T11:43:39.217Z"
      }
    ],
    "participantsCount": 2,
    "createdAt": "2025-09-25T10:32:50.265Z",
    "updatedAt": "2025-10-01T06:52:27.110Z",
    "lastMessage": {
      "_id": "68d51f2b9caa6111e7e8079a",
      "user": {
        "_id": "68c7f963d4ec4fd41b3e804b",
        "name": "Max_R",
        "username": "Max123_ABC",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68c7f963d4ec4fd41b3e804b/1759234752316-9879981848796738-1759234752043-a519dafb-e83a-42c2-aa30-3030dc9b0a9a.jpeg.jpg"
      },
      "chat": "68d51a529caa6111e7e801c7",
      "files": [
        {
          "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68d51a529caa6111e7e801c7/1758797609557-20670695416285156-1000231137.jpg",
          "meta": {
            "mediaType": "image",
            "fileName": "1000231137.jpg",
            "fileSize": 56808,
            "duration": null
          },
          "_id": "68d51f2b9caa6111e7e8079b"
        }
      ],
      "at": "2025-09-25T10:53:31.000Z"
    },
    "tags": [
      {
        "tag": "exams",
        "label": "Exams"
      },
      {
        "tag": "lectures",
        "label": "Lectures & Summaries"
      }
    ],
    "areYouAdmin": true,
    "name": "Neha Sharma",
    "unread": 0
  }
}
```

# 🔒 GET `/chats/:id/files`

## Description

- Returns the chat files as per chat id
- User must belong to that chat
- Default value of `type` is `video`
- Default value of `tag` is `others`

## Request Query

```js
{
  limit?: '10'
  page?: '1'
  tag?: string
  type?: ('video') | 'audio' | 'image' | 'document' | 'other'
}
```

## Response Body

```json
{
  "files": [
    {
      "_id": "68dceda44d3ce8d31c0468b8",
      "user": "68c7f963d4ec4fd41b3e804b",
      "chat": "68dbc1b214789cc4f67a9669",
      "at": "2025-10-01T09:00:20.000Z",
      "message": "68dceda44d3ce8d31c0468b7",
      "file": {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1757344169809-449191050525499-video.mp4",
        "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1757344169809-9816989786237902-cover.jpg",
        "meta": {
          "data": "Its just a dummy data",
          "list": [
            "It",
            "can",
            "have",
            "array",
            "too",
            true,
            100
          ],
          "note": "url is compulsory, rest cover and meta are optional and meta can have any type of data"
        },
        "_id": "68dceda44d3ce8d31c0468b8"
      }
    },
    {
      "_id": "68dceda44d3ce8d31c0468b9",
      "user": "68c7f963d4ec4fd41b3e804b",
      "chat": "68dbc1b214789cc4f67a9669",
      "at": "2025-10-01T09:00:20.000Z",
      "message": "68dceda44d3ce8d31c0468b7",
      "file": {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1757344169809-449191050525499-video.mp4",
        "_id": "68dceda44d3ce8d31c0468b9"
      }
    },
    {
      "_id": "68dbc5a014789cc4f67a998a",
      "user": "68ca8ae145040eb96218240d",
      "chat": "68dbc1b214789cc4f67a9669",
      "at": "2025-09-30T11:57:20.000Z",
      "message": "68dbc5a014789cc4f67a9989",
      "file": {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1759233420680-8447798295126582-1000001062.mp4",
        "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1759233418507-3706994323752095-thumbnail_.jpg",
        "meta": {
          "mediaType": "video",
          "fileName": "1000001062.mp4",
          "fileSize": 4467489,
          "duration": 42327
        },
        "_id": "68dbc5a014789cc4f67a998a"
      }
    },
    {
      "_id": "68dbc53514789cc4f67a98b6",
      "user": "68ca8ae145040eb96218240d",
      "chat": "68dbc1b214789cc4f67a9669",
      "at": "2025-09-30T11:55:33.000Z",
      "message": "68dbc53514789cc4f67a98b5",
      "file": {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1759233327467-31513544063118626-1000001064.mp4",
        "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1759233325355-21514774134559367-thumbnail_.jpg",
        "meta": {
          "mediaType": "video",
          "fileName": "1000001064.mp4",
          "fileSize": 4302200,
          "duration": 25157
        },
        "_id": "68dbc53514789cc4f67a98b6"
      }
    },
    {
      "_id": "68dbc52c14789cc4f67a9872",
      "user": "68ca8ae145040eb96218240d",
      "chat": "68dbc1b214789cc4f67a9669",
      "at": "2025-09-30T11:55:24.000Z",
      "message": "68dbc52c14789cc4f67a9871",
      "file": {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1759233313039-7893983894355104-1000001093.mp4",
        "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dbc1b214789cc4f67a9669/1759233310908-9275570189539417-thumbnail_.jpg",
        "meta": {
          "mediaType": "video",
          "fileName": "1000001093.mp4",
          "fileSize": 8913290,
          "duration": 47092
        },
        "_id": "68dbc52c14789cc4f67a9872"
      }
    }
  ],
  "count": 5
}
```

# 🔒 POST `/chats`

## Description

- Creates a new chat
- Send socket notification of `chat-created` to all users in this chat
- Also send socket notification to current user's other connected devices
- Create chat participants in both cases: group chat and one-to-one
- If `isGroup` is `false` and a one-to-one chat with this user already exist, then don't create a new chat, instead just send success response with `200` with same chat details
- `user` can not the same as ID of the current user
- `user` and `meetMe` is only required when its not a group chat
- `meetMe` is the `connection` id of these corresponding users and that connection must be `accepted`
- `socket` is the socket ID of the current user, if he's connected to websocket
- `name`, `category`, and `participants` is required when its a group chat
- If `meetMe` is given, also check if that status exist and belong to that user
- All participants must belong to the user's following list or the connected user
- If `category` is `Courses`, then `restricted` field will always be `false`
- Handle the blocking for one-to-one chat
- Push notify all participants if the chat is a group chat
- Socket ID follows this regex:

```js
/^[A-Za-z0-9\-_]{16,25}$/
```

## Request Body

```ts
{
  user?: '68914287e4c3076d9436523c',
  meetMe?: '68914287e4c3076d9436523c',
  isGroup?: false,
  category?: 'Event',
  name?: 'Math 101',
  participants?: ['68914287e4c3076d943698d3', '68914287e4c3076d943657823'],
  restricted?: true
  socket?: 'u3C2x9asfB9vE5y8A6AD'
}
```

## Response Body

```json
{
  "chat": {
    "creator": "68c7f963d4ec4fd41b3e804b",
    "isGroup": true,
    "category": "Event",
    "name": "Future Scientists",
    "allowPublicPost": true,
    "participants": [
      {
        "user": "68b5931b4d5c718924c59a40",
        "_id": "68dcf51fc12ff2a182ef2aba",
        "lastReadAt": "2025-10-01T09:32:15.000Z"
      },
      {
        "user": "68c7f963d4ec4fd41b3e804b",
        "isAdmin": true,
        "_id": "68dcf51fc12ff2a182ef2abb",
        "lastReadAt": "2025-10-01T09:32:15.000Z"
      }
    ],
    "restricted": true,
    "_id": "68dcf51fc12ff2a182ef2ab9",
    "tags": [
      {
        "tag": "exams",
        "label": "Exams"
      },
      {
        "tag": "lectures",
        "label": "Lectures & Summaries"
      }
    ],
    "createdAt": "2025-10-01T09:32:15.204Z",
    "updatedAt": "2025-10-01T09:32:15.204Z"
  }
}
```

# 🔒 PUT `/chats/:id`

## Description

- Update the chat details inc. photo
- Chat must be a group chat
- User must be the chat admin
- If `category` is `Courses`, then `restricted` field will always be `false`

## Request Body (Form Data)

```js
{
  photo?: File,
  name?: string,
  category?: string,
  restricted?: 'true' | 'false'
  allowPublicPost?: 'true' | 'false'
}
```

## Response Body

```json
{
  "chat": {
    "_id": "68dcf51fc12ff2a182ef2ab9",
    "creator": "68c7f963d4ec4fd41b3e804b",
    "isGroup": true,
    "name": "Future Scientists",
    "name": "Study",
    "participants": [
      {
        "user": "68b5931b4d5c718924c59a40",
        "_id": "68dcf51fc12ff2a182ef2aba",
        "lastReadAt": "2025-10-01T09:32:15.000Z"
      },
      {
        "user": "68c7f963d4ec4fd41b3e804b",
        "isAdmin": true,
        "_id": "68dcf51fc12ff2a182ef2abb",
        "lastReadAt": "2025-10-01T09:32:15.000Z"
      }
    ],
    "restricted": true,
    "tags": [
      {
        "tag": "exams",
        "label": "Exams"
      },
      {
        "tag": "lectures",
        "label": "Lectures & Summaries"
      }
    ],
    "createdAt": "2025-10-01T09:32:15.204Z",
    "updatedAt": "2025-10-01T09:37:04.878Z",
    "allowPublicPost": true,
    "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/chats/68dcf51fc12ff2a182ef2ab9/1759311422186-03632050593785774-tree.avif"
  }
}
```

# 🔒 POST `/chats/:id/read`

## Description

- Mark all messages in that chat as read
- User must belong to that chat as a participant

# 🔒 POST `/chats/:id/participants`

## Description

- Add user to that group chat as participant
- Chat Group should not be restricted
- User should not be an existing chat participant
- Chat must be group chat
- Socket notify that participant with event `chat-joined`
- `socket` is the socket ID of the current user, if he's connected to websocket
- Update `join-group-chat` action of vibe social score of that user and send socket notification with event `score-updated`

## Request Body

```ts
{
  socket?: 'u3C2x9asfB9vE5y8A6AD'
}
```

## Response Body

```json
{
  "participant": {
    "user": "68b5931b4d5c718924c59a40",
    "_id": "68d0f41d9f26a37074c7b7e4",
    "lastReadAt": "2025-09-22T07:00:45.000Z"
  }
}
```

# 🔒 POST `/chats/:id/participants/:participantId/status`

## Description

- Update participant status
- Participant must exist in this chat
- Chat must be group chat
- Chat must have an event
- User must be event's chat admin
- Event must be active
- Notify the participant

## Request Body

```ts
{
  status: 'accepted' | 'rejected'
}
```

# 🔒 POST `/chats/:id/participants/multiple`

## Description

- Add multiple users to that group chat as participants
- User must be chat admin
- Chat must be group chat
- All participants must belong to the user's following list or the connected user
- Filter only those participants which does not exist in that chat previously
- Socket notify all participants with event `chat-joined`
- FCM Push notify all participants with event `chat-joined`

## Request Body

```js
{
  participants: ['68914287e4c3076d943698d3', '68914287e4c3076d943657823'],
}
```

## Response Body

```json
{
  "participants": [
    {
      "user": "68914287e4c3076d943698d3",
      "_id": "68beebca57ab80b6986794e0",
      "lastReadAt": "2025-09-08T14:44:26.000Z"
    },
    {
      "user": "68914287e4c3076d943657823",
      "_id": "68beebca57ab80b6986794e1",
      "lastReadAt": "2025-09-08T14:44:26.000Z"
    }
  ],
}
```

# 🔒 DELETE `/chats/:id/participants/:participantId`

## Description

- Remove the participant for the chat list
- User can also remove itself without needing to be admin
- User and this participant must belong to that chat
- In order to remove other participant, user must be admin of that chat
- Chat must be group chat
- Atleast one admin should be present even after participant removal
- If done by other admin, FCM Push notify this participant with event `chat-access-removed`
- Socket notify other participants with event `chat-participant-removed`

## Request Body

```ts
{
  socket?: 'u3C2x9asfB9vE5y8A6AD'
}
```

# 🔒 POST `/chats/:id/participants/:participantId/admin`

## Description

- Add admin access for that participant
- User and this participant must belong to that chat
- User must be admin of that chat
- Chat must be group chat
- Notify the user with event `chat-admin-access-granted`

# 🔒 DELETE `/chats/:id/participants/:participantId/admin`

## Description

- Remove the admin access for this participant
- User can't remove its own admin access
- User and this participant must belong to that chat
- User must be admin of that chat
- Chat must be group chat
- Atleast one admin should be present even after participant removal
- Notify the user with event `chat-admin-access-removed`

# 🔒 DELETE `/chats/:id`

## Description

- Delete the chat
- If chat belongs to the event, then delete event also
- Deletes all its messages and files
- User must be chat admin
- Chat must be group chat
- Delete the chat photo also
- Send socket event to current user's other devices
- Send socket event to other users also

## Request Body

```js
{
  socket?: 'u3C2x9asfB9vE5y8A6AD'
}
```

# Links

[Goto Home](/docs/index.html)