"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Chat = void 0;
const mongoose_1 = require("mongoose");
const ChatTagSchema = new mongoose_1.Schema({
    tag: {
        type: String,
        required: true
    },
    label: {
        type: String,
        required: true
    }
}, { versionKey: false, _id: false });
const ChatParticipantSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true
    },
    isAdmin: Boolean,
    status: {
        type: String,
        enum: ['accepted', 'rejected']
    },
    lastReadAt: {
        type: Date,
        default: Date
    }
}, { versionKey: false });
const ChatSchema = new mongoose_1.Schema({
    creator: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User'
    },
    isGroup: Boolean,
    category: String,
    meetMe: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Connection'
    },
    event: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Event'
    },
    lastMessage: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Message'
    },
    blocked: Boolean,
    name: String,
    photo: String,
    allowPublicPost: {
        type: Boolean,
        required: false,
        default: true
    },
    tags: {
        type: [ChatTagSchema],
        default: [
            { tag: 'exams', label: 'Exams' },
            { tag: 'lectures', label: 'Lectures & Summaries' },
        ]
    },
    participants: {
        type: [ChatParticipantSchema],
        required: true
    },
    restricted: Boolean
}, { versionKey: false, timestamps: true });
ChatSchema.index({ 'participants.user': 1, updatedAt: -1 });
ChatSchema.index({ meetMe: 1 }, { partialFilterExpression: { meetMe: { $exists: true } } });
ChatSchema.index({ isGroup: 1, updatedAt: -1 }, { partialFilterExpression: { isGroup: true } });
exports.Chat = (0, mongoose_1.model)('Chat', ChatSchema, 'chats');
