"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const uploaders_1 = require("../../utils/uploaders");
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getChats, auth_1.default.authorizeUser, controllers_1.default.getChats);
router.get('/:id', validations_1.default.validateChatId, auth_1.default.authorizeUser, controllers_1.default.getChat);
router.get('/explore/communities', validations_1.default.getExploreChats, auth_1.default.authorizeUser, controllers_1.default.getExploreChats);
router.get('/:id/files', validations_1.default.getChatFiles, auth_1.default.authorizeUser, controllers_1.default.getChatFiles);
router.post('/', validations_1.default.postChat, auth_1.default.authorizeUser, controllers_1.default.postChat);
router.put('/:id', uploaders_1.ImageUploader.fields([{ name: 'photo', maxCount: 1 }]), validations_1.default.putChat, auth_1.default.authorizeUser, controllers_1.default.putChat);
router.post('/:id/read', validations_1.default.validateChatId, auth_1.default.authorizeUser, controllers_1.default.postChatRead);
router.post('/:id/participants', validations_1.default.postChatParticipant, auth_1.default.authorizeUser, controllers_1.default.postChatParticipant);
router.post('/:id/participants/multiple', validations_1.default.postChatParticipants, auth_1.default.authorizeUser, controllers_1.default.postChatParticipants);
router.post('/:id/participants/:participantId/status', validations_1.default.postChatParticipantStatus, auth_1.default.authorizeUser, controllers_1.default.postChatParticipantStatus);
router.delete('/:id/participants/:participantId', validations_1.default.deleteChatParticipant, auth_1.default.authorizeUser, controllers_1.default.deleteChatParticipant);
router.post('/:id/participants/:participantId/admin', validations_1.default.validateChatParticipantId, auth_1.default.authorizeUser, controllers_1.default.postChatParticipantAdmin);
router.delete('/:id/participants/:participantId/admin', validations_1.default.validateChatParticipantId, auth_1.default.authorizeUser, controllers_1.default.deleteChatParticipantAdmin);
router.delete('/:id', validations_1.default.validateChatId, auth_1.default.authorizeUser, controllers_1.default.deleteChat);
module.exports = router;
