"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Comment = void 0;
const mongoose_1 = require("mongoose");
const CommentDataSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
    },
    text: String
}, { versionKey: false, _id: false });
const CommentSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    reel: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Reel',
        required: true
    },
    parent: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Comment',
    },
    data: {
        type: [CommentDataSchema],
        required: true
    },
    superLike: {
        type: mongoose_1.Types.ObjectId,
        ref: 'SuperLike'
    },
    likes: {
        type: Number,
        default: 0
    },
    isKind: Boolean,
    isThankyou: Boolean,
    isNegative: Boolean,
}, { versionKey: false, timestamps: true });
CommentSchema.index({ superLike: -1, likes: -1, createdAt: -1 });
CommentSchema.index({ reel: 1, parent: 1, superLike: -1, likes: -1, createdAt: -1 });
CommentSchema.index({ parent: 1 });
CommentSchema.index({ reel: 1 });
exports.Comment = (0, mongoose_1.model)('Comment', CommentSchema, 'comments');
