"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getComments, auth_1.default.authorizeUser, controllers_1.default.getComments);
router.post('/', validations_1.default.postComment, auth_1.default.authorizeUser, controllers_1.default.postComment);
router.patch('/:id', validations_1.default.patchComment, auth_1.default.authorizeUser, controllers_1.default.patchComment);
router.delete('/:id', validations_1.default.deleteComment, auth_1.default.authorizeUser, controllers_1.default.deleteComment);
module.exports = router;
