"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
function getComments(req, res, next) {
    try {
        const rules = {
            reel: 'mongoid',
            parent: 'optional|mongoid',
            limit: 'optional|string|natural',
            page: 'optional|string|natural',
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.query);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postComment(req, res, next) {
    try {
        const rules = {
            reel: 'mongoid',
            parent: 'optional|mongoid',
            data: [
                {
                    text: 'optional|string|min:1|max:500',
                    user: 'optional|mongoid',
                    $atleast: 'text|user'
                }
            ]
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function patchComment(req, res, next) {
    try {
        const rules = {
            id: 'mongoid',
            data: [
                {
                    text: 'optional|string|min:1|max:500',
                    user: 'optional|mongoid',
                    $atleast: 'text|user'
                }
            ]
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, Object.assign(Object.assign({}, req.body), req.params));
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function deleteComment(req, res, next) {
    try {
        const rules = {
            id: 'mongoid'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.params);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    getComments,
    postComment,
    patchComment,
    deleteComment
};
exports.default = validations;
