[Goto Home](/docs/index.html)

# 🔒 GET `/connections`

## Description

- Returns the list of all connections of that user as per pagination

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items
- **status** - optional; possible values (`pending`, `accepted`); apply status filter

## Response Body

```json
{
  "connections": [
    {
      "_id": "68c14b067a0f59ec129e61e8",
      "from": {
        "_id": "688c51572b675be4b88339d1",
        "name": "John Doe",
        "username": "john.doe",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
        "bio": "I am a workaholic"
      },
      "to": {
        "_id": "68b5931b4d5c718924c59a40",
        "username": "raj.example",
        "name": "Raj Kr",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
      },
      "status": "accepted",
      "createdAt": "2025-09-10T09:55:18.000Z",
      "acceptedAt": "2025-09-10T09:57:17.872Z",
      "user": {
        "_id": "688c51572b675be4b88339d1",
        "name": "John Doe",
        "username": "john.doe",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/688c51572b675be4b88339d1/1754037385298-15741700714483675-forest_2364458.png",
        "bio": "I am a workaholic"
      }
    },
    {
      "_id": "68c145b511c8c90ebc3a4cd0",
      "from": {
        "_id": "68b5931b4d5c718924c59a40",
        "username": "raj.example",
        "name": "Raj Kr",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
      },
      "to": {
        "_id": "68ac3f6dd7f5a437029aa88f",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ac3f6dd7f5a437029aa88f/1758007790332-16697659211217097-1758007788161-f05c235e-a4de-4519-8615-ed9802295e9d.jpeg.jpg",
        "name": "Jass Singh",
        "username": "bat_ma_n",
        "bio": "New Bio"
      },
      "status": "pending",
      "createdAt": "2025-09-10T09:32:37.000Z",
      "user": {
        "_id": "68ac3f6dd7f5a437029aa88f",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68ac3f6dd7f5a437029aa88f/1758007790332-16697659211217097-1758007788161-f05c235e-a4de-4519-8615-ed9802295e9d.jpeg.jpg",
        "name": "Jass Singh",
        "username": "bat_ma_n",
        "bio": "New Bio"
      }
    }
  ],
  "count": 2
}
```

# 🔒 POST `/connections/:userId`

## Description

- Creates a new connection
- If a previous connection for that user already exist with different `statusDetail`, then update its `statusDetail`
- If a previous connection for that user already exist with same `statusDetail`, then reject the api
- Target user must have a status and it must be active
- Also check if user previous status is expired or not
- `userId` can not the same as ID of the current user
- Notify user with event `connection-request`
- Update `create-meetme-request` action of vibe social score of that user and send socket notification with event `score-updated`
- Handle user blocking case

## Response Body

```json
{
  "connection": {
    "from": "68914287e4c3076d9436523c",
    "to": "68906b08a3bf95fd187f7a22",
    "status": "pending",
    "_id": "689a250918fd373e193935e6",
    "createdAt": "2025-08-11T17:14:49.000Z"
  }
}
```

# 🔒 POST `/connections/:userId/accept`

## Description

- Accept the connection
- User must belong to that connection
- User must belong to the `to` field of that connection
- `userId` should not be same as current `user._id`
- Connection should not be accepted
- Also delete both user profile status field if expired
- Notify user with event `connection-accepted`
- Update social vibe score and send socket notification with event `score-updated`
- Update `add-new-friend` action of vibe social score of that user and send socket notification with event `score-updated`
- Handle user blocking case

## Response Body

```json
{
  "connection": {
    "_id": "689a26c16cbaee0c43c7baed",
    "from": "688c51572b675be4b88339d1",
    "to": "68914287e4c3076d9436523c",
    "status": "accepted",
    "createdAt": "2025-08-11T17:22:09.000Z",
    "acceptedAt": "2025-08-11T17:32:35.784Z"
  }
}
```

# 🔒 DELETE `/connections/:userId`

## Description

- Delete the current connection
- Connection with meet me should not be accepted
- Also delete both user profile status field if expired
- User must belong to that collection
- `userId` should not be same as current `user._id`
- If deleted by the connection creator and status is pending, then delete the previous notification also

# Links

[Goto Home](/docs/index.html)