"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connection = void 0;
const mongoose_1 = require("mongoose");
const ConnectionSchema = new mongoose_1.Schema({
    from: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    to: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    statusDetail: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Status',
    },
    status: {
        type: String,
        enum: ['pending', 'accepted'],
        default: 'pending',
    },
    chat: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Chat'
    },
    createdAt: {
        type: Date,
        default: Date
    },
    acceptedAt: Date
}, { versionKey: false });
exports.Connection = (0, mongoose_1.model)('Connection', ConnectionSchema, 'connections');
