"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
function postContactUs(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { name, email, phone, message } = req.body;
            const user = res.locals.user;
            yield models_1.ContactUs.create({
                user: user === null || user === void 0 ? void 0 : user._id,
                name,
                email,
                phone,
                message
            });
            return res.status(201).json({ message: 'contact request submitted successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    postContactUs
};
exports.default = controllers;
