"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
function postContacts(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { contacts } = req.body;
            const user = res.locals.user;
            let contact = yield models_1.Contact.findOne({ user: user._id });
            if (contact) {
                contact.contacts = contacts;
                yield contact.save();
                return res.json({ message: 'contacts sync successfully' });
            }
            yield models_1.Contact.create({
                user: user._id,
                contacts
            });
            return res.status(201).json({ message: 'contacts sync successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    postContacts
};
exports.default = controllers;
