"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Contact = void 0;
const mongoose_1 = require("mongoose");
const ContactSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
        unique: true
    },
    contacts: {
        type: [Object],
        default: []
    }
}, { versionKey: false, timestamps: true });
exports.Contact = (0, mongoose_1.model)('Contact', ContactSchema, 'contacts');
