"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deletion = void 0;
const mongoose_1 = require("mongoose");
const constants_1 = __importDefault(require("../../utils/constants"));
const DeletionSchema = new mongoose_1.Schema({
    collections: {
        type: String,
        required: true
    },
    user: {
        type: mongoose_1.Types.ObjectId,
        enum: constants_1.default.collections,
        ref: 'User'
    },
    data: {
        type: mongoose_1.Schema.Types.Mixed,
        required: true
    },
    at: {
        type: Date,
        default: Date
    }
}, { versionKey: false });
exports.Deletion = (0, mongoose_1.model)('Deletion', DeletionSchema, 'deletions');
