"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Event = void 0;
const mongoose_1 = require("mongoose");
const types_1 = require("../../utils/types");
const EventSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    title: {
        type: String,
        required: true,
    },
    description: {
        type: String,
        required: true,
    },
    date: {
        type: String,
        required: true
    },
    time: {
        type: String,
        required: true
    },
    location: {
        type: types_1.LocationSchema,
        required: true
    },
    locationString: {
        type: String,
        required: true
    },
    chat: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Chat',
        required: true
    },
    category: {
        type: String,
        required: true,
    },
    cover: String,
    startedAt: {
        type: Date,
        required: true,
    },
    endedAt: {
        type: Date,
        required: true,
    },
}, { versionKey: false, timestamps: true });
EventSchema.index({ location: '2dsphere' });
exports.Event = (0, mongoose_1.model)('Event', EventSchema, 'events');
