"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const uploaders_1 = require("../../utils/uploaders");
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getEvents, auth_1.default.authorizeUser, controllers_1.default.getEvents);
router.get('/:id', validations_1.default.checkEventId, auth_1.default.authorizeUser, controllers_1.default.getEvent);
router.post('/', uploaders_1.ImageUploader.single('cover'), validations_1.default.postEvent, auth_1.default.authorizeUser, controllers_1.default.postEvent);
router.patch('/:id', uploaders_1.ImageUploader.single('cover'), validations_1.default.patchEvent, auth_1.default.authorizeUser, controllers_1.default.patchEvent);
router.post('/opened-view-all', auth_1.default.authorizeUser, controllers_1.default.postOpenedViewAll);
module.exports = router;
