"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("../users/models");
const models_2 = require("./models");
const services_1 = __importDefault(require("../../utils/services"));
const models_3 = require("../mutual-follows/models");
function getFollowers(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const user = res.locals.user;
            let { limit = '10', page = '1', user: userId, type = 'followers' } = req.query;
            limit = +limit;
            page = +page;
            const targetUserId = userId || user._id.toString();
            if (userId) {
                const targetUser = yield models_1.User.findById(userId);
                if (!targetUser) {
                    return res.status(404).json({ message: 'user not found' });
                }
            }
            let match = {};
            if (type === 'followers') {
                // All users who follow targetUserId
                match = { following: targetUserId };
            }
            else {
                // All users targetUserId is following
                match = { follower: targetUserId };
            }
            const followersDocs = yield models_2.Follower.find(match)
                .skip((page - 1) * limit)
                .limit(limit);
            // Extract the IDs of the other users we want details for
            const userIds = followersDocs.map(doc => type === 'followers' ? doc.follower : doc.following);
            const users = yield models_1.User.find({ _id: { $in: userIds } }, {
                name: 1,
                username: 1,
                bio: 1,
                auth: { emailVerified: 1, phoneVerified: 1 },
                photo: 1,
                createdAt: 1
            });
            const count = yield models_2.Follower.countDocuments(match);
            return res.json({ users, count });
        }
        catch (error) {
            console.error(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function postFollower(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const userId = req.params.userId;
            const user = res.locals.user;
            if (userId === user._id.toString()) {
                return res.status(403).json({ message: 'cannot follow yourself' });
            }
            let [targetUser, follower] = yield Promise.all([
                models_1.User.findById(userId),
                models_2.Follower.findOne({ follower: user._id, following: userId })
            ]);
            if (!targetUser) {
                return res.status(404).json({ message: 'user not found' });
            }
            if (follower) {
                return res.json({ message: 'following successfully' });
            }
            const isBlocked = yield services_1.default.isUserBlocked(user._id, targetUser._id);
            if (isBlocked) {
                return res.status(403).json({ message: "Can't unfollow when its blocked" });
            }
            follower = yield models_2.Follower.create({
                follower: user._id,
                following: userId
            });
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    const currentUserFollowingsCount = yield models_2.Follower.countDocuments({ follower: user._id });
                    user.followings = currentUserFollowingsCount;
                    yield user.save();
                    const targetUserFollowersCount = yield models_2.Follower.countDocuments({ following: userId });
                    yield models_1.User.updateOne({ _id: userId }, { $set: { followers: targetUserFollowersCount } });
                    const following = yield models_2.Follower.findOne({ following: user._id, follower: userId });
                    if (following) {
                        const mutualFollow = yield models_3.MutualFollow.findOne({ users: { $all: [user._id, targetUser._id] } });
                        if (!mutualFollow) {
                            yield models_3.MutualFollow.create({ users: [user._id, targetUser._id] });
                        }
                    }
                    yield services_1.default.notifyUser({
                        title: 'Your New Follower',
                        description: `${user.username} has started following you`,
                        event: 'user-followed',
                        user: targetUser,
                        follower: follower._id,
                        from: user._id,
                    });
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            return res.status(201).json({ message: 'following successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function deleteFollower(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const userId = req.params.userId;
            const user = res.locals.user;
            if (userId === user._id.toString()) {
                return res.status(400).json({ message: 'Cannot unfollow yourself' });
            }
            const targetUser = yield models_1.User.findById(userId);
            if (!targetUser) {
                return res.status(404).json({ message: 'user not found' });
            }
            const isBlocked = yield services_1.default.isUserBlocked(user._id, targetUser._id);
            if (isBlocked) {
                return res.status(403).json({ message: "Can't unfollow when its blocked" });
            }
            yield models_2.Follower.deleteOne({ follower: user._id, following: userId });
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    const currentUserFollowingsCount = yield models_2.Follower.countDocuments({ follower: user._id });
                    user.followings = currentUserFollowingsCount;
                    yield user.save();
                    const targetUserFollowersCount = yield models_2.Follower.countDocuments({ following: userId });
                    targetUser.followers = targetUserFollowersCount;
                    yield targetUser.save();
                    yield models_3.MutualFollow.deleteOne({ users: { $all: [user._id, targetUser._id] } });
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            return res.json({ message: 'unfollowed successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    getFollowers,
    postFollower,
    deleteFollower
};
exports.default = controllers;
