[Goto Home](/docs/index.html)

# 🔒 GET `/followers`

## Description

- Returns the list of matching followers/followings
- Target user must exist

## Request Query

- **limit** - default `10`; set the number of items to return on each page
- **page** - default `1`; set the page for which to return the items
- **user** - ID of the user of which to return the followers/followings list; If not given, then assume the current user
- **type** - default `followers`; possible values: (`followers`, `followings`); If type=`followers`, then it returns all the followers of that user otherwise it returns followings

## Response Body

```json
{
  "users": [
    {
      "_id": "66b72a4f9f8c4f001f3e6a11",
      "name": "Alice Johnson",
      "username": "alicej",
      "bio": "Full-stack developer and coffee enthusiast ☕",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "photo": "/uploads/photos/alicej.jpg",
      "createdAt": "2025-06-15T09:32:21.000Z"
    },
    {
      "_id": "66b72a4f9f8c4f001f3e6a12",
      "name": "Michael Chen",
      "username": "mikechen",
      "bio": "iOS Engineer @TechWorld",
      "auth": {
        "emailVerified": true,
        "phoneVerified": true
      },
      "photo": "/uploads/photos/mikechen.png",
      "createdAt": "2025-05-10T12:15:54.000Z"
    }
  ],
  "count": 2
}
```

# 🔒 POST `/followers/:userId`

## Description

- Follow that user with status code `201`
- If already following, then return success with status code `200`
- Update the `followers`/`followings` count in both user profile
- Target user must exist
- Notify user with event `user-followed`
- Update `mutual-follows`
- Handle the user blocking

# 🔒 DELETE `/followers/:userId`

## Description

- Unfollow that user
- If already not following then also return success status
- Update the `followers`/`followings` count in both user profile
- Target user must exist
- Update `mutual-follows`
- Handle the user blocking

# Links

[Goto Home](/docs/index.html)