"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Follower = void 0;
const mongoose_1 = require("mongoose");
const FollowerSchema = new mongoose_1.Schema({
    follower: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    following: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    at: {
        type: Date,
        default: Date
    }
}, { versionKey: false });
FollowerSchema.index({ follower: 1, following: 1 }, { unique: true });
exports.Follower = (0, mongoose_1.model)('Follower', FollowerSchema, 'followers');
