"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
function getFollowers(req, res, next) {
    try {
        const rules = {
            limit: 'optional|string|natural',
            page: 'optional|string|natural',
            user: 'optional|mongoid',
            type: 'optional|string|enums:followers,followings'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.query);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function checkUser(req, res, next) {
    try {
        const rules = {
            userId: 'mongoid'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.params);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    getFollowers,
    checkUser
};
exports.default = validations;
