"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
const models_2 = require("../reels/models");
const models_3 = require("../comments/models");
const services_1 = __importDefault(require("../../utils/services"));
function postLike(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const user = res.locals.user;
            const { reel: reelId, comment: commentId } = req.body;
            let reel, comment, commentUser;
            if (reelId) {
                reel = (yield models_2.Reel.findById(reelId).populate('user'));
                if (!reel) {
                    return res.status(404).json({ message: 'reel not found' });
                }
            }
            else {
                // @ts-ignore
                comment = (yield models_3.Comment.findById(commentId).populate('user'));
                if (!comment) {
                    return res.status(404).json({ message: 'comment not found' });
                }
                // @ts-ignore
                commentUser = comment.user;
                reel = (yield models_2.Reel.findById(comment.reel));
                if (!reel) {
                    return res.status(404).json({ message: 'reel not found' });
                }
            }
            const query = reelId ? { reel: reel._id } : { comment: comment._id };
            let like = yield models_1.Like.findOne(Object.assign({ user: user._id }, query));
            if (like) {
                return res.status(200).json({ message: 'already liked' });
            }
            // @ts-ignore
            like = yield models_1.Like.create(Object.assign({ user: user._id }, query));
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    const count = yield models_1.Like.countDocuments(Object.assign({}, query));
                    if (reelId) {
                        reel.likes = count;
                        yield reel.save();
                    }
                    else {
                        comment.likes = count;
                        yield comment.save();
                    }
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            if (reelId && `${reel.user._id}` !== `${user._id}`) {
                yield services_1.default.notifyUser({
                    title: 'Your vibe got a new like',
                    description: `${user.username} liked your vibe`,
                    event: 'reel-liked',
                    user: reel.user,
                    from: user._id,
                    reel: reel._id,
                    like: like._id
                });
            }
            // @ts-ignore
            if (commentId && `${commentUser._id}` !== `${user._id}`) {
                yield services_1.default.notifyUser({
                    title: 'Your comment got a new like',
                    description: `${user.username} liked your comment`,
                    event: 'comment-liked',
                    user: commentUser,
                    from: user._id,
                    reel: reel._id,
                    comment: comment._id,
                    like: like._id
                });
            }
            return res.status(201).json({ message: 'liked successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function deleteLike(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const user = res.locals.user;
            const { reel: reelId, comment: commentId } = req.body;
            let reel, comment;
            if (reelId) {
                reel = (yield models_2.Reel.findById(reelId));
                if (!reel) {
                    return res.status(404).json({ message: 'reel not found' });
                }
            }
            else {
                comment = (yield models_3.Comment.findById(commentId));
                if (!comment) {
                    return res.status(404).json({ message: 'comment not found' });
                }
                reel = (yield models_2.Reel.findById(comment.reel));
                if (!reel) {
                    return res.status(404).json({ message: 'reel not found' });
                }
            }
            const query = reelId ? { reel: reel._id } : { comment: comment._id };
            const like = yield models_1.Like.findOne(Object.assign({ user: user._id }, query));
            if (!like) {
                return res.status(200).json({ message: 'already un-liked' });
            }
            (() => __awaiter(this, void 0, void 0, function* () {
                try {
                    yield like.deleteOne();
                    const count = yield models_1.Like.countDocuments(Object.assign({}, query));
                    if (reelId) {
                        reel.likes = count;
                        yield reel.save();
                    }
                    else {
                        comment.likes = count;
                        yield comment.save();
                    }
                }
                catch (error) {
                    console.log(error);
                }
            }))();
            return res.json({ message: 'un-liked successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    postLike,
    deleteLike
};
exports.default = controllers;
