"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.post('/', validations_1.default.checkLike, auth_1.default.authorizeUser, controllers_1.default.postLike);
router.delete('/', validations_1.default.checkLike, auth_1.default.authorizeUser, controllers_1.default.deleteLike);
module.exports = router;
