"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
function checkLike(req, res, next) {
    try {
        const rules = {
            reel: 'optional|mongoid',
            comment: 'optional|mongoid',
            $atleast: 'reel|comment',
            $atmost: 'reel|comment',
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    checkLike
};
exports.default = validations;
