"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Message = void 0;
const mongoose_1 = require("mongoose");
const MessageFileSchema = new mongoose_1.Schema({
    url: {
        type: String,
        required: true
    },
    cover: String,
    meta: Object
}, { versionKey: false });
const MessageSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    chat: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Chat',
        required: true
    },
    reel: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Reel',
    },
    content: String,
    files: {
        type: [MessageFileSchema],
        default: undefined
    },
    tag: String,
    at: {
        type: Date,
        default: Date
    }
}, { versionKey: false });
MessageSchema.index({ chat: 1, at: 1 });
MessageSchema.index({ chat: 1, at: -1 });
exports.Message = (0, mongoose_1.model)('Message', MessageSchema, 'messages');
