"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/:chatId', validations_1.default.getMessages, auth_1.default.authorizeUser, controllers_1.default.getMessages);
router.post('/', validations_1.default.postMessage, auth_1.default.authorizeUser, controllers_1.default.postMessage);
router.post('/share-reels', validations_1.default.postMessageShareReels, auth_1.default.authorizeUser, controllers_1.default.postMessageShareReels);
router.patch('/:id', validations_1.default.patchMessage, auth_1.default.authorizeUser, controllers_1.default.patchMessage);
router.delete('/:id', validations_1.default.deleteMessage, auth_1.default.authorizeUser, controllers_1.default.deleteMessage);
router.post('/presign-url', validations_1.default.postPresignUrl, auth_1.default.authorizeUser, controllers_1.default.postPresignUrl);
module.exports = router;
