"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
const services_1 = __importDefault(require("../../utils/services"));
const models_1 = require("../chats/models");
const messageSockets = {};
messageSockets['typing-started'] = (socket, data) => __awaiter(void 0, void 0, void 0, function* () {
    yield handleTypingUpdateSocketListener(socket, data, 'started');
});
messageSockets['typing-stopped'] = (socket, data) => __awaiter(void 0, void 0, void 0, function* () {
    yield handleTypingUpdateSocketListener(socket, data, 'stopped');
});
function handleTypingUpdateSocketListener(socket, data, type) {
    return __awaiter(this, void 0, void 0, function* () {
        const user = socket.data.user;
        const rule = { chat: 'mongoid' };
        const { errors } = (0, super_easy_validator_1.validate)(rule, data);
        if (errors) {
            return services_1.default.socketErrorNotifyUser(socket, 'validation-failed', { message: errors[0] });
        }
        const chat = yield models_1.Chat.findById(data.chat);
        if (!chat) {
            return services_1.default.socketErrorNotifyUser(socket, 'not-found', { message: 'chat not found' });
        }
        const currentParticipant = chat.participants.find(e => `${e.user}` === `${user._id}`);
        if (!currentParticipant) {
            return services_1.default.socketErrorNotifyUser(socket, 'permission-denied', { message: 'permission denied' });
        }
        // notify every participants in this chat (excluding current user) that typing is started/stopped
        const participants = chat.participants
            .map(e => `${e.user}`)
            .filter(e => e !== `${user._id}`);
        for (const participant of participants) {
            const payload = {
                user: {
                    _id: `${user._id}`,
                    name: user.name,
                    username: user.username,
                    photo: user.photo,
                },
                chat: `${chat._id}`
            };
            services_1.default.socketNotifyUser({
                userId: participant,
                event: type === 'started' ? 'typing-started' : 'typing-stopped',
                data: payload
            });
        }
    });
}
exports.default = messageSockets;
