"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
const constants_1 = __importDefault(require("../../utils/constants"));
function getMessages(req, res, next) {
    try {
        const rules = {
            limit: 'optional|string|natural',
            page: 'optional|string|natural'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.query);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postMessage(req, res, next) {
    try {
        const rules = {
            chat: 'mongoid',
            content: 'optional|string|min:1|max:2000',
            files: 'optional|array|min:1|max:20|arrayof:object',
            socket: `optional|${constants_1.default.socketRegex}`
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        if (req.body.files) {
            const rules = {
                files: [
                    {
                        url: 'url',
                        cover: 'optional|url',
                        meta: 'optional'
                    }
                ]
            };
            const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
            if (errors) {
                return res.status(400).json({ message: errors[0] });
            }
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postMessageShareReels(req, res, next) {
    try {
        const rules = {
            chats: 'arrayof:mongoid',
            reel: 'mongoid',
            socket: `optional|${constants_1.default.socketRegex}`
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function patchMessage(req, res, next) {
    try {
        const rules = {
            id: 'mongoid',
            tag: 'nullable|string|min:1|max:25'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, Object.assign(Object.assign({}, req.params), req.body));
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function deleteMessage(req, res, next) {
    try {
        const rules = {
            id: 'mongoid'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.params);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
function postPresignUrl(req, res, next) {
    try {
        const rules = {
            chat: 'mongoid',
            files: 'arrayof:string|arrayof:min:5|arrayof:max:300'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    getMessages,
    postMessage,
    postMessageShareReels,
    patchMessage,
    deleteMessage,
    postPresignUrl
};
exports.default = validations;
