"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
const constants_1 = __importDefault(require("../../utils/constants"));
function getMiscVersion(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const misc = yield models_1.Misc.findById("common");
            if (!misc) {
                return res.status(404).json({ message: 'miscellaneous not found' });
            }
            return res.json({ version: misc.version });
        }
        catch (error) {
            console.error(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function postScheduler(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { id, event, data } = req.body;
            res.sendStatus(200);
            const handler = constants_1.default.scheduleHandlers[event];
            yield (handler === null || handler === void 0 ? void 0 : handler(data));
            console.log('❇️ Schedule consumed:', id);
        }
        catch (error) {
            console.error(error);
        }
    });
}
const controllers = {
    getMiscVersion,
    postScheduler
};
exports.default = controllers;
