"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Misc = void 0;
const mongoose_1 = require("mongoose");
const MiscVersionSchema = new mongoose_1.Schema({
    latestVersionString: {
        type: String,
        required: true
    },
    latestVersionCode: {
        type: Number,
        required: true
    },
    minimumVersionString: {
        type: String,
        required: true
    },
    minimumVersionCode: {
        type: Number,
        required: true
    },
}, { versionKey: false, _id: false });
const MiscVersionPlatformSchema = new mongoose_1.Schema({
    android: {
        type: MiscVersionSchema,
        required: true
    },
    ios: {
        type: MiscVersionSchema,
        required: true
    },
}, { versionKey: false, _id: false });
const MiscSchema = new mongoose_1.Schema({
    _id: {
        type: String,
        required: true,
    },
    version: {
        type: MiscVersionPlatformSchema,
        required: true,
    },
}, { versionKey: false });
exports.Misc = (0, mongoose_1.model)('Misc', MiscSchema, 'misc');
