"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const super_easy_validator_1 = require("super-easy-validator");
const types_1 = require("../../utils/types");
function postScheduler(req, res, next) {
    try {
        const rules = {
            id: 'string|min:10',
            event: `string|enums:${types_1.scheduleEvents.join(',')}`,
            data: 'object'
        };
        const { errors } = (0, super_easy_validator_1.validate)(rules, req.body);
        if (errors) {
            return res.status(400).json({ message: errors[0] });
        }
        return next();
    }
    catch (error) {
        console.log(error);
        return res.status(500).json({ message: 'server error' });
    }
}
const validations = {
    postScheduler
};
exports.default = validations;
