"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Notification = void 0;
const mongoose_1 = require("mongoose");
const constants_1 = __importDefault(require("../../utils/constants"));
const NotificationSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    data: Object,
    title: {
        type: String,
        required: true
    },
    description: {
        type: String,
        required: true
    },
    event: {
        type: String,
        required: true,
        enum: constants_1.default.notificationEvents,
    },
    from: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
    },
    comment: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Comment',
    },
    connection: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Connection',
    },
    follower: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Follower',
    },
    like: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Like',
    },
    superLike: {
        type: mongoose_1.Types.ObjectId,
        ref: 'SuperLike',
    },
    reel: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Reel',
    },
    status: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Status',
    },
    request: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Request',
    },
    chat: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Chat',
    },
    meetMeEvent: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Event',
    },
    rewardHash: {
        type: mongoose_1.Types.ObjectId,
        ref: 'RewardHash',
    },
    read: Boolean,
    dismissed: Boolean,
    at: {
        type: Date,
        default: Date
    }
}, { versionKey: false });
exports.Notification = (0, mongoose_1.model)('Notification', NotificationSchema, 'notifications');
