"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getNotifications, auth_1.default.authorizeUser, controllers_1.default.getNotifications);
router.post('/:id/read', validations_1.default.postNotificationRead, auth_1.default.authorizeUser, controllers_1.default.postNotificationRead);
router.post('/read-all', auth_1.default.authorizeUser, controllers_1.default.postAllNotificationsRead);
module.exports = router;
