"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("../models");
const models_2 = require("../../deletions/models");
const controllers_1 = __importDefault(require("../controllers"));
function deleteReel(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const id = req.params.id;
            const reel = yield models_1.Reel.findById(id).populate('user');
            if (!reel) {
                return res.status(404).json({ message: 'reel not found' });
            }
            const user = reel.user;
            yield models_2.Deletion.create({
                collections: 'reels',
                user: user._id,
                data: reel
            });
            controllers_1.default.deleteReelAndItsAssets(reel, user, false);
            return res.json({ message: 'reel deleted successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    deleteReel
};
exports.default = controllers;
