"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sample = {
    _id: '1756289963348-2634455742348135',
    cover: 'https://example.com/adventure.png',
    video: 'https://example.com/adventure.mp4',
    question: 'Should he take left path or right path ?',
    children: [
        {
            _id: '1756289963348-8831047611828214',
            label: 'Left Path',
            cover: 'https://example.com/left-path.jpg',
            video: 'https://example.com/left-path.mp4',
            question: 'Should he jump off the cliff ?',
            children: [
                {
                    _id: '1756289963348-9693272529539749',
                    label: 'Yes',
                    cover: 'https://example.com/jump-off-cliff.jpg',
                    video: 'https://example.com/jump-off-cliff.mp4',
                    children: null,
                },
                {
                    _id: '1756289963348-3712436283225051',
                    label: 'No',
                    cover: 'https://example.com/dont-jump.jpg',
                    video: 'https://example.com/dont-jump.mp4',
                    children: null,
                },
            ],
        },
        {
            _id: '1756289963348-2720435720565354',
            label: 'Right Path',
            cover: 'https://example.com/right-path.png',
            video: 'https://example.com/right-path.mp4',
            question: 'Should be jump of the running train ?',
            children: [
                {
                    _id: '1756289963348-30873016530957376',
                    label: 'Yes',
                    cover: 'https://example.com/jump-off-train.png',
                    video: 'https://example.com/jump-off-train.mp4',
                    children: null,
                },
                {
                    _id: '1756289963348-0474776060058143',
                    label: 'No',
                    cover: 'https://example.com/dont-jump.jpg',
                    video: 'https://example.com/dont-jump.mp4',
                    children: null,
                },
            ],
        },
    ],
};
const serialized = [
    {
        _id: '1756289963348-2634455742348135',
        cover: 'https://example.com/adventure.png',
        video: 'https://example.com/adventure.mp4',
        question: 'Should he take left path or right path ?',
    },
    {
        _id: '1756289963348-8831047611828214',
        parent: '1756289963348-2634455742348135',
        label: 'Left Path',
        cover: 'https://example.com/left-path.jpg',
        video: 'https://example.com/left-path.mp4',
        question: 'Should he jump off the cliff ?',
    },
    {
        _id: '1756289963348-9693272529539749',
        parent: '1756289963348-8831047611828214',
        label: 'Yes',
        cover: 'https://example.com/jump-off-cliff.jpg',
        video: 'https://example.com/jump-off-cliff.mp4',
    },
    {
        _id: '1756289963348-3712436283225051',
        parent: '1756289963348-8831047611828214',
        label: 'No',
        cover: 'https://example.com/dont-jump.jpg',
        video: 'https://example.com/dont-jump.mp4',
    },
    {
        _id: '1756289963348-2720435720565354',
        parent: '1756289963348-2634455742348135',
        label: 'Right Path',
        cover: 'https://example.com/right-path.png',
        video: 'https://example.com/right-path.mp4',
        question: 'Should be jump of the running train ?',
    },
    {
        _id: '1756289963348-30873016530957376',
        parent: '1756289963348-2720435720565354',
        label: 'Yes',
        cover: 'https://example.com/jump-off-train.png',
        video: 'https://example.com/jump-off-train.mp4',
    },
    {
        _id: '1756289963348-0474776060058143',
        parent: '1756289963348-2720435720565354',
        label: 'No',
        cover: 'https://example.com/dont-jump.jpg',
        video: 'https://example.com/dont-jump.mp4',
    },
];
function nestedDynamicToFlat(dynamic, list = [], parent) {
    let { _id, label, cover, video, question, children } = dynamic;
    if (!_id || (typeof _id === 'string' && !/^[0-9a-f]{24}$/.test(_id))) {
        _id = Date.now() + '-' + Math.random().toString().substring(2);
        dynamic._id = _id;
    }
    const entry = Object.assign({ _id, label, cover, video, question }, (parent ? { parent: parent._id } : {}));
    list.push(entry);
    if (children === null || children === void 0 ? void 0 : children.length) {
        for (const child of children) {
            nestedDynamicToFlat(child, list, dynamic);
        }
    }
    return list;
}
function flatDynamicToNested(serialized) {
    const insertEntryInDynamic = (dynamic, entry, root) => {
        const { _id, label, cover, video, question, parent } = entry;
        if (!dynamic) {
            dynamic = { _id, label, cover, video, question, children: [] };
            return root !== null && root !== void 0 ? root : dynamic;
        }
        if (!dynamic.children) {
            dynamic.children = [];
        }
        if (parent && dynamic._id === parent) {
            dynamic.children.push({ _id, label, cover, video, question });
        }
        for (const child of dynamic.children) {
            root = insertEntryInDynamic(child, entry, root);
        }
        if (!dynamic.children.length) {
            dynamic.children = undefined;
        }
        return root;
    };
    let dynamic = undefined;
    for (const entry of serialized) {
        if (entry.parent) {
            dynamic = insertEntryInDynamic(dynamic, entry, dynamic);
        }
        else {
            const { _id, label, cover, video, question } = entry;
            dynamic = { _id, label, cover, video, question, children: [] };
        }
    }
    return dynamic;
}
// const list = nestedDynamicToFlat(sample)
// console.log(list)
const nested = flatDynamicToNested(serialized);
console.dir(nested, { depth: null });
