"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reel = void 0;
const mongoose_1 = require("mongoose");
const ReelPhotoSchema = new mongoose_1.Schema({
    url: {
        type: String,
        required: true
    },
}, { versionKey: false, _id: false });
const ReelMetaDataSchema = new mongoose_1.Schema({
    comments: String,
    vectorMetaData: {
        type: [Number],
        default: undefined,
    },
    isPositive: Boolean,
    isNegative: Boolean,
    awarenessExercise: {
        type: [String],
        default: undefined,
        enum: ['mindful-breathing', 'noticing-sound', 'body-awareness', 'focus-on-object', 'cloud-watching', 'mindful-walking', 'gratitude-anchor']
    },
    groundingExercise: {
        type: [String],
        default: undefined,
        enum: ['54321-technique', 'body-scan', 'box-breathing', 'object-focus', 'name-label-emotions', 'mindful-walk-scroll', 'name-surroundings']
    },
    isProductivity: Boolean,
    isMeditation: Boolean,
}, { versionKey: false, _id: false });
const DynamicEntrySchema = new mongoose_1.Schema({
    _id: {
        type: String,
        required: true,
    },
    parent: String,
    label: String,
    cover: String,
    video: {
        type: String,
        required: true
    },
    question: String
}, { versionKey: false });
const ReelCompressionResultSchema = new mongoose_1.Schema({
    isCompleted: Boolean,
    errors: Object
}, { versionKey: false, _id: false });
const ReelSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    chat: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Chat',
    },
    message: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Message',
    },
    event: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Event',
    },
    description: String,
    tag: String,
    subTag: String,
    cover: String,
    video: String,
    compressionResult: {
        type: ReelCompressionResultSchema,
        default: {}
    },
    dynamic: {
        type: [DynamicEntrySchema],
        required: false,
        default: undefined
    },
    vectorIndex: {
        type: [Number],
        default: [],
    },
    hashtags: {
        type: [String],
        default: []
    },
    photos: {
        type: [ReelPhotoSchema],
        default: undefined,
    },
    metaData: ReelMetaDataSchema,
    song: String,
    chips: {
        type: [String],
        enum: ['focus', 'mindfulness', 'reflection'],
        default: undefined
    },
    isAnonymous: Boolean,
    views: {
        type: Number,
        default: 0
    },
    likes: {
        type: Number,
        default: 0
    },
    superLikes: {
        type: Number,
        default: 0
    },
    shares: {
        type: Number,
        default: 0
    },
    comments: {
        type: Number,
        default: 0
    },
    reports: {
        type: Number,
        default: 0
    },
    favorites: {
        type: Number,
        default: 0
    },
}, { versionKey: false, timestamps: true });
exports.Reel = (0, mongoose_1.model)('Reel', ReelSchema, 'reels');
