[Goto Home](/docs/index.html)

# 🔒 GET `/reels`

## Description

- Returns the reels for home page
- These reels will be suggested by AI
- Since it returns AI suggested reels randomly, so there won't be any pagination
- Doesn't return the current user reel
- Don't return user details if reel's `isAnonymous` is `true`
- Also return - `isFollowed`, `isLiked`, `isSuperLiked`, `isFavorite`
- If chips is given, it will return only 1 video

## Request Query

- **limit** - default `10`, set the number of items to return on each api call
- **dynamic** - default `false`, if `true`, it will only show dynamic based reels
- **chips** - possible values: `focus`, `mindfulness`, `reflection`

## Response Body

```json
{
  "reels": [
    {
      "_id": "68a2f0f8a64cd0088270de83",
      "user": {
        "_id": "68906b08a3bf95fd187f7a22",
        "auth": {
          "emailVerified": true,
          "phoneVerified": false
        },
        "createdAt": "2025-08-04T08:10:48.716Z",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
        "name": "Jassi Singh",
        "username": "mr_scanner1",
        "bio": "Let's connect",
        "isFollowed": true
      },
      "tag": "courses",
      "subTag": "computer science",
      "description": "Move like them, but never think like them",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-cover.png",
      "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-8557698547342135-mindset.mp4",
      "chips": ["focus"],
      "hashtags": [
        "mindset"
      ],
      "isAnonymous": false,
      "views": 0,
      "likes": 0,
      "superLikes": 0,
      "shares": 0,
      "comments": 0,
      "createdAt": "2025-08-18T09:28:42.053Z",
      "updatedAt": "2025-08-18T09:28:42.053Z",
      "isLiked": false,
      "isSuperLiked": false,
      "isFavorite": false
    }
  ]
}
```

# 🔒 GET `/reels/explore`

## Description

- Returns the trending reels for explore
- Only return non-anonymous reels
- Also return the fields - `isFollowed`, `isLiked`, `isSuperLiked`, `isFavorite`

## Request Query

- **limit** - default `10`, set the number of items to return on each api call
- **page** - default `1`, set the page number for which api has to return data
- **chat** - it sets the chat group id from which to extract the reel videos
- **tag** - it sets the tag filter on the reels

## Response Body

```json
{
  "reels": [
    {
      "_id": "68a2f0f8a64cd0088270de83",
      "user": {
        "_id": "68906b08a3bf95fd187f7a22",
        "auth": {
          "emailVerified": true,
          "phoneVerified": false
        },
        "createdAt": "2025-08-04T08:10:48.716Z",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
        "name": "Jassi Singh",
        "username": "mr_scanner1",
        "bio": "Let's connect",
        "isFollowed": true
      },
      "chat": "68ee530a808e28d0b11beec9",
      "tag": "courses",
      "subTag": "computer science",
      "description": "Move like them, but never think like them",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-cover.png",
      "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-8557698547342135-mindset.mp4",
      "hashtags": [
        "mindset"
      ],
      "isAnonymous": false,
      "views": 0,
      "likes": 0,
      "superLikes": 0,
      "shares": 0,
      "comments": 0,
      "createdAt": "2025-08-18T09:28:42.053Z",
      "updatedAt": "2025-08-18T09:28:42.053Z",
      "isLiked": false,
      "isSuperLiked": false,
      "isFavorite": false
    }
  ],
  "count": 2
}
```

# 🔒 GET `/reels/user/:userId`

## Description

- Returns the reels of that user only as per pagination
- Don't return anonymous reels if the current user ID is different from `userId`
- Also return views and likes for each reel

## Request Query

- **limit** - default `10`, set the number of items to return on each api call
- **page** - default `1`, set the page number

## Response Body

```json
{
  "reels": [
    {
      "_id": "68a2f0f8a64cd0088270de83",
      "user": "68906b08a3bf95fd187f7a22",
      "description": "Move like them, but never think like them",
      "tag": "courses",
      "subTag": "computer science",
      "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-cover.png",
      "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-8557698547342135-mindset.mp4",
      "hashtags": [
        "mindset"
      ],
      "isAnonymous": false,
      "views": 0,
      "likes": 0,
      "superLikes": 0,
      "shares": 0,
      "comments": 0,
      "reports": 0,
      "favorites": 0,
      "createdAt": "2025-08-18T09:28:42.053Z",
      "updatedAt": "2025-08-18T09:28:42.053Z",
      "isLiked": true,
      "isSuperLiked": true,
      "isFavorite": true
    }
  ],
  "count": 1
}
```

# 🔒 GET `/reels/:id`

## Description

- Returns the reel details
- If the reel is anonymous and does not created by current user, then don't return the reel details
- Also return - likes, superLikes, isFollowed, isLiked, isSuperLiked, comments, shared

## Response Body

```json
{
  "reel": {
    "_id": "68a2f0f8a64cd0088270de83",
    "user": {
      "_id": "68906b08a3bf95fd187f7a22",
      "auth": {
        "emailVerified": true,
        "phoneVerified": false
      },
      "createdAt": "2025-08-04T08:10:48.716Z",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68906b08a3bf95fd187f7a22/1754389726864-11352239567863498-1754389725491-7560383e-1930-4c67-bcca-4e0835815860.jpeg.jpg",
      "name": "Jassi Singh",
      "username": "mr_scanner1",
      "bio": "Let's connect",
      "isFollowed": true
    },
    "description": "Move like them, but never think like them",
    "tag": "courses",
    "subTag": "computer science",
    "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-cover.png",
    "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-8557698547342135-mindset.mp4",
    "hashtags": [
      "mindset"
    ],
    "isAnonymous": false,
    "views": 0,
    "likes": 0,
    "superLikes": 0,
    "shares": 0,
    "comments": 0,
    "createdAt": "2025-08-18T09:28:42.053Z",
    "updatedAt": "2025-08-18T09:28:42.053Z",
    "isLiked": false,
    "isSuperLiked": false,
    "isFavorite": true
  }
}
```

# 🔒 POST `/reels/presign-url`

## Description

- Generates presign url for every file
- `id` is optional and it used internally to categorized files based on reel's id folder. If not provided, then it generates a new one
- `id` must be provided, when going to change the cover image of an existing reel

## Request Body

```ts
{
  id?: '6899c1bbabe4f0b09ab85a46'
  files: ['mindset.mp4', 'cover.jpg']
}
```

## Response Body

```json
{
  "id": "68a2f0f8a64cd0088270de83",
  "urls": [
    {
      "file": "mindset.mp4",
      "upload": "https://vibe-dev.bb8af9bf43323edeaeeedf6cfe096189.r2.cloudflarestorage.com/reels/68a2f0f8a64cd0088270de83/1755508984234-8557698547342135-mindset.mp4?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Content-Sha256=UNSIGNED-PAYLOAD&X-Amz-Credential=4da98f4064954d2e9c950aa33e1c72ee%2F20250818%2Fauto%2Fs3%2Faws4_request&X-Amz-Date=20250818T092304Z&X-Amz-Expires=1200&X-Amz-Signature=b28510e22685e53ad0f38c331f64ea04ba19df3262af068d6fb64d20071ef745&X-Amz-SignedHeaders=host&x-amz-checksum-crc32=AAAAAA%3D%3D&x-amz-sdk-checksum-algorithm=CRC32&x-id=PutObject",
      "download": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-8557698547342135-mindset.mp4"
    },
    {
      "file": "cover.png",
      "upload": "https://vibe-dev.bb8af9bf43323edeaeeedf6cfe096189.r2.cloudflarestorage.com/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-cover.png?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Content-Sha256=UNSIGNED-PAYLOAD&X-Amz-Credential=4da98f4064954d2e9c950aa33e1c72ee%2F20250818%2Fauto%2Fs3%2Faws4_request&X-Amz-Date=20250818T092304Z&X-Amz-Expires=1200&X-Amz-Signature=8eaa55b83b0d348a092976b10f12375b145d579354f0fdb9b14c10a325330109&X-Amz-SignedHeaders=host&x-amz-checksum-crc32=AAAAAA%3D%3D&x-amz-sdk-checksum-algorithm=CRC32&x-id=PutObject",
      "download": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-cover.png"
    }
  ]
}
```

# 🌍 PUT `<presign-url>`

## Description

- Uploads the file on the presign url which is given by previous file
- There won't be any response body in this case, just a status code of `200`

## Request Body

```
<Binary File>
```

# 🔒 POST `/reels`

## Description

- Create a new reel
- one and only one of `video`, `photos` or `dynamic` should be given
- Add the reel video to queue (if video exists), so that it can be precessed by AI
- `null` in dynamic is just for structure idea, don't pass `null` anywhere in `dynamic` object
- Update user's `posts` count
- If chat is given, then:
  - it must be a group chat
  - if its `allowPublicPost` is not true, then user must be admin
  - if its event chat, then also add event field
  - create a new message in that chat with this reel id
  - also add this message id in that reel
  - Marks all messages as read in that chat
  - Update chat's `lastMessage` field
  - Push Notify other users in that chat with event `message-received`
  - `socket` is the socket ID of the current user, if he's connected to websocket
  - Socket notify other users in that chat with socket event of `message-received`
  - Socket Notify current user's other devices with event `message-sent`
  - message object will also get returned

## Request Body

```ts
{
  id: 'mongoid',
  chat?: 'mongoid',
  tag?: 'courses',
  subTag?: 'computer science',
  description?: 'My day today',
  cover?: 'https://download.com/video/cover.png',
  video?: 'https://download.com/video/abc.mp4',
  photos?: ['https://download.com/images/abc.png', 'https://download.com/images/123.jpg'],
  dynamic?: {
    label: null,  // null is just for structure idea, don't pass null anywhere in dynamic
    cover: 'https://example.com/adventure.png',
    video: 'https://example.com/adventure.mp4',
    question: 'Should he take left path or right path ?',
    children: [
      {
        label: 'Left Path',
        cover: 'https://example.com/left-path.jpg',
        video: 'https://example.com/left-path.mp4',
        question: 'Should he jump off the cliff ?',
        children: [
          {
            label: 'Yes',
            cover: 'https://example.com/jump-off-cliff.jpg',
            video: 'https://example.com/jump-off-cliff.mp4',
            question: null,
            children: null,
          },
          {
            label: 'No',
            cover: 'https://example.com/dont-jump.jpg',
            video: 'https://example.com/dont-jump.mp4',
            question: null,
            children: null,
          },
        ],
      },
      {
        label: 'Right Path',
        cover: 'https://example.com/right-path.png',
        video: 'https://example.com/right-path.mp4',
        question: 'Should be jump of the running train ?',
        children: [
          {
            label: 'Yes',
            cover: 'https://example.com/jump-off-train.png',
            video: 'https://example.com/jump-off-train.mp4',
            question: null,
            children: null,
          },
          {
            label: 'No',
            cover: 'https://example.com/dont-jump.jpg',
            video: 'https://example.com/dont-jump.mp4',
            question: null,
            children: null,
          },
        ],
      },
    ],
  },
  hashtags?: ['trends', 'blog'],
  isAnonymous?: true,
  socket?: 'u3C2x9asfB9vE5y8A6AD'
}
```

## Response Body

```json
{
  "reel": {
    "user": "68906b08a3bf95fd187f7a22",
    "description": "Move like them, but never think like them",
    "cover": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-cover.png",
    "video": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-8557698547342135-mindset.mp4",
    "photos": [
      {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-abc.png"
      },
      {
        "url": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/reels/68a2f0f8a64cd0088270de83/1755508984234-13163024562999048-123.jpg"
      }
    ],
    "tag": "courses",
    "subTag": "computer science",
    "dynamic": {
      "_id": "1756290643616-8261571200691745",
      "cover": "https://example.com/adventure.png",
      "video": "https://example.com/adventure.mp4",
      "question": "Should he take left path or right path ?",
      "children": [
        {
          "_id": "1756290643616-5212796332005196",
          "label": "Left Path",
          "cover": "https://example.com/left-path.jpg",
          "video": "https://example.com/left-path.mp4",
          "question": "Should he jump off the cliff ?",
          "children": [
            {
              "_id": "1756290643616-8007686859684454",
              "label": "Yes",
              "cover": "https://example.com/jump-off-cliff.jpg",
              "video": "https://example.com/jump-off-cliff.mp4"
            },
            {
              "_id": "1756290643616-7327796156076626",
              "label": "No",
              "cover": "https://example.com/dont-jump.jpg",
              "video": "https://example.com/dont-jump.mp4"
            }
          ]
        },
        {
          "_id": "1756290643616-5522145005916935",
          "label": "Right Path",
          "cover": "https://example.com/right-path.png",
          "video": "https://example.com/right-path.mp4",
          "question": "Should be jump of the running train ?",
          "children": [
            {
              "_id": "1756290643616-27383094319395485",
              "label": "Yes",
              "cover": "https://example.com/jump-off-train.png",
              "video": "https://example.com/jump-off-train.mp4"
            },
            {
              "_id": "1756290643616-3725293372305426",
              "label": "No",
              "cover": "https://example.com/dont-jump.jpg",
              "video": "https://example.com/dont-jump.mp4"
            }
          ]
        }
      ]
    },
    "hashtags": [
      "mindset"
    ],
    "isAnonymous": false,
    "views": 0,
    "likes": 0,
    "superLikes": 0,
    "shares": 0,
    "comments": 0,
    "reports": 0,
    "favorites": 0,
    "_id": "68a2f0f8a64cd0088270de83",
    "createdAt": "2025-08-18T09:26:31.070Z",
    "updatedAt": "2025-08-18T09:26:31.070Z"
  },
  "message?": {
    "user": "689b1fca132cd7d169e76e2d",
    "chat": "68e7536e877ea11a33be92e0",
    "reel": "69049529fa7e82996321d4c4",
    "_id": "690495a4ef4fdf219d147a7e",
    "at": "2025-10-31T10:55:32.000Z"
  }
}
```

# 🔒 PATCH `/reels/:id`

## Description

- Update the reel details
- User must be the creator of that reel
- Delete cover image on R2 if previously exist

## Request Body

```ts
{
  tag?: 'courses',
  subTag?: 'computer science',
  description?: 'My day today',
  hashtags?: ['trends', 'blogs'],
  isAnonymous?: true,
  cover?: 'https://download.com/video/cover.png',
}
```

# 🔒 DELETE `/reels/:id`

## Description

- Delete the reel
- User must be the creator of that reel
- Delete all corresponding files on R2
- Also delete corresponding views, likes, super-likes, comments, shares, favorites of that reel
- Update users `posts` count

# Links

[Goto Home](/docs/index.html)