"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../utils/auth"));
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getReels, auth_1.default.authorizeUser, controllers_1.default.getReels);
router.get('/explore', validations_1.default.getExploreReels, auth_1.default.authorizeUser, controllers_1.default.getExploreReels);
router.get('/user/:userId', validations_1.default.getUserReels, auth_1.default.authorizeUser, controllers_1.default.getUserReels);
router.get('/:id', validations_1.default.checkReelId, auth_1.default.authorizeUser, controllers_1.default.getReel);
router.post('/presign-url', validations_1.default.postPresignUrl, auth_1.default.authorizeUser, controllers_1.default.postPresignUrl);
router.post('/', validations_1.default.postReel, auth_1.default.authorizeUser, controllers_1.default.postReel);
router.patch('/:id', validations_1.default.patchReel, auth_1.default.authorizeUser, controllers_1.default.patchReel);
router.delete('/:id', validations_1.default.checkReelId, auth_1.default.authorizeUser, controllers_1.default.deleteReel);
module.exports = router;
