"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("./models");
const models_2 = require("../reels/models");
function postReport(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { reel: reelId, category, message } = req.body;
            const user = res.locals.user;
            const reel = yield models_2.Reel.findById(reelId);
            if (!reel) {
                return res.status(404).json({ message: 'reel not found' });
            }
            yield models_1.Report.create({
                reportedBy: user._id,
                user: reel.user,
                reel: reel._id,
                category,
                message
            });
            return res.status(201).json({ message: 'reel reported successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    postReport
};
exports.default = controllers;
