"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Report = void 0;
const mongoose_1 = require("mongoose");
const ReportSchema = new mongoose_1.Schema({
    reportedBy: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true
    },
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true
    },
    reel: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Reel',
        required: true
    },
    category: {
        type: String,
        required: true
    },
    message: String
}, { versionKey: false, timestamps: true });
exports.Report = (0, mongoose_1.model)('Report', ReportSchema, 'reports');
