"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Request = void 0;
const mongoose_1 = require("mongoose");
const RequestSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        ref: 'User',
        required: true,
    },
    chat: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Chat',
        required: true
    },
    status: {
        type: String,
        enum: ['pending', 'accepted', 'rejected'],
        default: 'pending',
    },
    createdAt: {
        type: Date,
        default: Date
    },
    acceptedAt: Date,
    rejectedAt: Date,
}, { versionKey: false });
exports.Request = (0, mongoose_1.model)('Request', RequestSchema, 'requests');
