[Goto Home](/docs/index.html)

# 🔒 GET `/requests`

## Description

- Returns the list of all requests of that user

## Request Query

- **limit** - default `10`, set the number of items to return on each page
- **page** - default `1`, set the page for which to return the items
- **status** - optional; possible values (`pending`, `accepted`, `rejected`); apply status filter

## Response Body

```json
{
  "requests": [
    {
      "_id": "68d0fb69b0b26538e53b286f",
      "user": {
        "_id": "68b5931b4d5c718924c59a40",
        "username": "raj.example",
        "name": "Raj Kr",
        "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
      },
      "chat": {
        "_id": "68d0f3cf9f26a37074c7b7d9",
        "creator": "689b1fca132cd7d169e76e2d",
        "isGroup": true,
        "areYouAdmin": true,
        "name": "Chat With Amy and Others",
        "participants": [
          {
            "user": "68914287e4c3076d9436523c",
            "_id": "68d0f3cf9f26a37074c7b7da",
            "lastReadAt": "2025-09-22T06:59:27.000Z"
          },
          {
            "user": "689b1fca132cd7d169e76e2d",
            "isAdmin": true,
            "_id": "68d0f3cf9f26a37074c7b7db",
            "lastReadAt": "2025-09-22T06:59:27.000Z"
          }
        ],
        "createdAt": "2025-09-22T06:59:27.715Z",
        "updatedAt": "2025-09-22T07:08:42.132Z",
        "restricted": true
      },
      "status": "pending",
      "createdAt": "2025-09-22T07:31:53.000Z"
    }
  ],
  "count": 1
}
```

# 🔒 GET `/requests/:id`

## Description

- Returns the request details as per id
- Request must be created by that user

## Response Body

```json
{
  "request": {
    "_id": "68d0fb69b0b26538e53b286f",
    "user": {
      "_id": "68b5931b4d5c718924c59a40",
      "username": "raj.example",
      "name": "Raj Kr",
      "photo": "https://pub-569168ecc9d940c3892a9d7197875513.r2.dev/users/68b5931b4d5c718924c59a40/1757342480919-7356470458539326-boat.png"
    },
    "chat": {
      "_id": "68d0f3cf9f26a37074c7b7d9",
      "creator": "689b1fca132cd7d169e76e2d",
      "isGroup": true,
      "areYouAdmin": true,
      "name": "Chat With Amy and Others",
      "participants": [
        {
          "user": "68914287e4c3076d9436523c",
          "_id": "68d0f3cf9f26a37074c7b7da",
          "lastReadAt": "2025-09-22T06:59:27.000Z"
        },
        {
          "user": "689b1fca132cd7d169e76e2d",
          "isAdmin": true,
          "_id": "68d0f3cf9f26a37074c7b7db",
          "lastReadAt": "2025-09-22T06:59:27.000Z"
        }
      ],
      "createdAt": "2025-09-22T06:59:27.715Z",
      "updatedAt": "2025-09-22T07:08:42.132Z",
      "restricted": true
    },
    "status": "pending",
    "createdAt": "2025-09-22T07:31:53.000Z"
  }
}
```

# 🔒 POST `/requests`

## Description

- Creates a new request
- A previous `pending` request for that user and chat should not exist
- Chat group must be restricted
- Chat must be group chat
- User must not be the active participant of that group chat
- Notify the chat admins with event `chat-join-request`

## Request Body

```json
{
  "chat": "68914287e4c3076d9436523c"
}
```

## Response Body

```json
{
  "request": {
    "user": "68b5931b4d5c718924c59a40",
    "chat": "68d0f3cf9f26a37074c7b7d9",
    "status": "pending",
    "_id": "68d0fb69b0b26538e53b286f",
    "createdAt": "2025-09-22T07:31:53.000Z"
  }
}
```

# 🔒 PATCH `/requests/:id`

## Description

- Accept/Reject the request
- User must belong to that chat 
- User must be the chat admin
- Previous Request status must be `pending`
- If `status` is `accepted`, then add the participant into chat participants list
- Notify user with event `chat-request-accepted` if its accepted
- Also mark its corresponding notification as `dismissed`
- If `accepted`, Update `join-group-chat` action of vibe social score of the request sender and send socket notification with event `score-updated`

## Request Body

```js
{
  status: 'accepted' | 'rejected'
}
```

# Links

[Goto Home](/docs/index.html)