"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RewardHash = void 0;
const mongoose_1 = require("mongoose");
const RewardHashSchema = new mongoose_1.Schema({
    user: {
        type: mongoose_1.Types.ObjectId,
        required: true,
        ref: 'User'
    },
    reward: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Reward'
    },
    hash: {
        type: String,
        required: true
    },
    isConsumed: Boolean,
    isMeetme: Boolean,
    score: {
        type: mongoose_1.Types.ObjectId,
        ref: 'Score'
    },
    at: {
        type: Date,
        default: Date,
    }
}, { versionKey: false });
exports.RewardHash = (0, mongoose_1.model)('RewardHash', RewardHashSchema, 'reward-hashes');
