"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const models_1 = require("../models");
const helpers_1 = __importDefault(require("../../../utils/helpers"));
function getRewards(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let { limit = '10', page = '1', search, isMeetme, isActive } = req.query;
            limit = +limit;
            page = +page;
            const skip = (page - 1) * limit;
            const query = { $and: [] };
            if (search) {
                query.$and.push({
                    $or: [{ title: RegExp(search, 'i') }, { description: RegExp(search, 'i') }]
                });
            }
            if (isMeetme === 'true') {
                query.isMeetme = true;
            }
            else if (isMeetme === 'false') {
                query.$and.push({
                    $or: [{ isMeetme: false }, { isMeetme: { $exists: false } }]
                });
            }
            if (isActive === 'true') {
                query.remaining = { $gt: 0 };
                query.$and.push({ $or: [
                        { expiredAt: { $exists: false } },
                        { expiredAt: { $gte: new Date() } }
                    ] });
            }
            const rewards = yield models_1.Reward
                .find(query)
                .sort({ createdAt: -1 })
                .skip(skip)
                .limit(limit);
            const count = yield models_1.Reward.countDocuments(query);
            return res.json({ rewards, count });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function getReward(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { id } = req.params;
            const reward = yield models_1.Reward.findById(id);
            if (!reward) {
                return res.status(404).json({ message: 'reward not found' });
            }
            return res.json({ reward });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function postReward(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            let { title, description, total, latitude, longitude, locationString, isMeetme, coupon, expiredAt } = req.body;
            const image = req.file;
            // creating reward
            total = +total;
            let data = {
                title,
                description,
                total,
                remaining: total,
                isMeetme: isMeetme === 'true',
                coupon: coupon || undefined,
                expiredAt: expiredAt ? new Date(expiredAt) : undefined
            };
            if (typeof latitude === 'string' && typeof longitude === 'string' && typeof locationString === 'string') {
                data.location = {
                    type: 'Point',
                    coordinates: [+longitude, +latitude]
                };
                data.locationString = locationString;
            }
            const reward = new models_1.Reward(data);
            // uploading cover image
            const path = `rewards/${reward._id}/${image.filename}`;
            const cover = yield helpers_1.default.uploadFile(image, path);
            if (!cover) {
                return res.status(500).json({ message: 'server error while uploading cover' });
            }
            reward.cover = cover;
            helpers_1.default.deleteFile(image);
            // saving data
            yield reward.save();
            return res.status(201).json({ reward });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
function deleteReward(req, res) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const { id } = req.params;
            const reward = yield models_1.Reward.findById(id);
            if (!reward) {
                return res.status(404).json({ message: 'reward not found' });
            }
            if (reward.remaining < reward.total) {
                return res.status(403).json({ message: 'reward can\'t be deleted after its claimed once' });
            }
            yield helpers_1.default.deleteR2File(reward.cover);
            yield reward.deleteOne();
            return res.json({ message: 'reward deleted successfully' });
        }
        catch (error) {
            console.log(error);
            return res.status(500).json({ message: 'server error' });
        }
    });
}
const controllers = {
    getRewards,
    getReward,
    postReward,
    deleteReward
};
exports.default = controllers;
