"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const validations_1 = __importDefault(require("./validations"));
const controllers_1 = __importDefault(require("./controllers"));
const auth_1 = __importDefault(require("../../../utils/auth"));
const uploaders_1 = require("../../../utils/uploaders");
const router = (0, express_1.Router)();
router.get('/', validations_1.default.getRewards, auth_1.default.authorizeAdmin, controllers_1.default.getRewards);
router.get('/:id', validations_1.default.getReward, auth_1.default.authorizeAdmin, controllers_1.default.getReward);
router.post('/', uploaders_1.ImageUploader.single('cover'), validations_1.default.postReward, auth_1.default.authorizeAdmin, controllers_1.default.postReward);
router.delete('/:id', validations_1.default.getReward, auth_1.default.authorizeAdmin, controllers_1.default.deleteReward);
module.exports = router;
