"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Reward = void 0;
const mongoose_1 = require("mongoose");
const types_1 = require("../../utils/types");
const RewardSchema = new mongoose_1.Schema({
    title: {
        type: String,
        required: true
    },
    description: {
        type: String,
        required: true
    },
    cover: {
        type: String,
        required: true
    },
    total: {
        type: Number,
        required: true
    },
    remaining: {
        type: Number,
        required: true
    },
    coupon: String,
    isMeetme: Boolean,
    location: types_1.LocationSchema,
    locationString: String,
    expiredAt: Date
}, { versionKey: false, timestamps: true });
RewardSchema.index({ location: '2dsphere' });
exports.Reward = (0, mongoose_1.model)('Reward', RewardSchema, 'rewards');
